﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO

Public Class ReadLargeFilePanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents FileContentsListBox As System.Windows.Forms.ListBox


    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.FileContentsListBox = New System.Windows.Forms.ListBox
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.AutoSize = False
        Me.DescriptionTextBox.Location = New System.Drawing.Point(7, 20)
        Me.DescriptionTextBox.Multiline = True
        Me.DescriptionTextBox.Size = New System.Drawing.Size(568, 47)
        Me.DescriptionTextBox.Text = "When reading very large files, it is often necessary to read the file iteratively" & _
            " rather than all at once.  My.Computer.FileSystem.OpenTextFileReader provides ac" & _
            "cess to a Stream object that enables more granular file access."
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.FileContentsListBox)
        Me.GroupBox2.Controls.SetChildIndex(Me.FileContentsListBox, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        '
        'FileContentsListBox
        '
        Me.FileContentsListBox.FormattingEnabled = True
        Me.FileContentsListBox.Location = New System.Drawing.Point(25, 187)
        Me.FileContentsListBox.Name = "FileContentsListBox"
        Me.FileContentsListBox.SelectionMode = System.Windows.Forms.SelectionMode.None
        Me.FileContentsListBox.Size = New System.Drawing.Size(538, 186)
        Me.FileContentsListBox.TabIndex = 4
        '
        'ReadLargeFilePanel
        '
        Me.Name = "ReadLargeFilePanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As ReadLargeFilePanel
    Friend WithEvents readFileFileChooser As New FileChooser()
    Friend WithEvents encodingComboBox As New ComboBox()

    ''' <summary>
    ''' 获取此面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As ReadLargeFilePanel
        If (panelInstance Is Nothing) Then
            panelInstance = New ReadLargeFilePanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 将所需控件添加到该面板
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ReadFile_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("filename", readFileFileChooser)
        MyBase.AddParameter("encoding", encodingComboBox)
    End Sub

    ''' <summary>
    ''' 将这些控件设置为它们的默认值
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.OpenTextFileReader("
        readFileFileChooser.Reset()
        encodingComboBox.Items.AddRange(New String() {"ASCII", "BigEndianUnicode", "Unicode", "UTF7", "UTF8", "UTF32"})
        encodingComboBox.AutoSize = True
        encodingComboBox.SelectedItem = "ASCII"
    End Sub

    ''' <summary>
    ''' 读取文件，一次读取一行，直到到达文件末尾
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            ' 打开流读取器并将所读取的每一行添加到列表框中。在到达流末尾时停止。
            Using reader As StreamReader = My.Computer.FileSystem.OpenTextFileReader( _
                                                            file:=readFileFileChooser.Filename, _
                                                            encoding:=ParseEncoding(CType(Me.encodingComboBox.SelectedItem, String)))
                FileContentsListBox.Items.Clear()
                While (Not reader.EndOfStream)
                    Me.FileContentsListBox.Items.Add(reader.ReadLine())
                End While
            End Using
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 将这些控件重置为它们的默认值
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

End Class
